#include <pwm.h>
#include <p30fxxxx.h>

/* PWM1-3 are defined in following devices */
#if defined(__dsPIC30F2010__) || defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || \
    defined(__dsPIC30F3011__) || defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5015__)

/**********************************************************************
* Function Name     :ConfigIntMCPWM
* Description       :This function Enable/Disable interrupts and 
*                    sets Interrupt priority for period match, 
*                    FaultA and FaultB.  
* Parameters        :unsigned int Config
* Return Value      :None 
**********************************************************************/

void ConfigIntMCPWM(unsigned int config)
{
    /* clear the Interrupt flags */
    IFS2bits.PWMIF = 0;	
    IFS2bits.FLTAIF = 0;	

    /* Set priority for the period match */
    IPC9bits.PWMIP      = (0x0007 & config);

    /* Set priority for the Fault A */
    IPC10bits.FLTAIP    = (0x0070 & config)>> 4;

    /* enable /disable of interrupt Period match */
    IEC2bits.PWMIE      = (0x0008 & config) >> 3;

    /* enable /disable of interrupt Fault A.*/
    IEC2bits.FLTAIE     = (0x0080 & config) >> 7;

#if defined(__dsPIC30F6010a2__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5015__)
    /* clear the Interrupt flags */
    IFS2bits.FLTBIF = 0;	

    /* Set priority for the Fault B */
    IPC11bits.FLTBIP    = (0x0700 & config)>>8;

    /* enable /disable of interrupt Fault B.*/
    IEC2bits.FLTBIE     = (0x0800 & config) >> 11;

#endif

}

#endif
